//=============================================================================
//
//
//
//
//
//=============================================================================
#define		ORBITER_MODULE
#include	"math.h"
#include	"orbitersdk.h"
#include	"stdio.h"
#include	"soyuz_capsule.h"

HINSTANCE	h_DLL;

const		double		EMPTY_MASS = 2800;
const		double		COGdx = 0.0;
const		double		COGdy = -0.4;
const		double		COGdz = 0.8;
const		double		SLE_ISP = 2600;
const		double		SLE_MAX_THRUST = 41867;
const		double		SLE_CAPACITY = 12.88*2;//*100;
const		double		R_SLE = 0.75;
const		double		S02 = 14;
const		double		S01 = 1000;

const		VECTOR3		COGro = {COGdx, COGdy, COGdz};
const		VECTOR3		CS = {2.9, 2.9, 3.0};
const		VECTOR3		PMI = {0.73, 0.73, 0.42};
const		VECTOR3		RotDrag = {0.7, 0.7, 0.3};
const		VECTOR3		TP1 = {0.0, -1.0, 0.1};
const		VECTOR3		TP2 = {-cos(30*RAD), sin(30*RAD), 0.1};
const		VECTOR3		TP3 = {cos(30*RAD), sin(30*RAD), 0.1};

VECTOR3		Door_Shift = {0.0, 0.0, 1.7};
VECTOR3		Main_Shute_Shift = {0.0, 0.0, 1.8};
VECTOR3		Brake_Shute_Shift = {-0.467, 0.462, 1.296};

const		VECTOR3		RS_REF = {0, 0, 0};
const		VECTOR3		RS_DIR = {0, 0, -1};
const		VECTOR3		RS_ROT = {1, 0, 0};

const		VECTOR3		SD_REF = {-0.467, 0.462, 1.296};
const		VECTOR3		SD_DIR = {-cos(45*RAD)*sin(70*RAD), sin(45*RAD)*sin(70*RAD), cos(70*RAD)};
const		VECTOR3		SD_ROT = {cos(45*RAD), sin(45*RAD), 0};

const		VECTOR3		SLE01_REF = {R_SLE*cos(30*RAD), R_SLE*sin(30*RAD), 0.181};
//const		VECTOR3		SLE01_DIR = {-cos(15*RAD)*sin(30*RAD), -sin(15*RAD)*sin(30*RAD), cos(30*RAD)};
const		VECTOR3		SLE02_REF = {R_SLE*cos(150*RAD), R_SLE*sin(150*RAD), 0.181};
//const		VECTOR3		SLE02_DIR = {-cos(75*RAD)*sin(30*RAD), -sin(75*RAD)*sin(30*RAD), cos(30*RAD)};
const		VECTOR3		SLE03_REF = {R_SLE*cos(210*RAD), R_SLE*sin(210*RAD), 0.181};
//const		VECTOR3		SLE03_DIR = {-cos(195*RAD)*sin(30*RAD), -sin(195*RAD)*sin(30*RAD), cos(30*RAD)};
const		VECTOR3		SLE04_REF = {R_SLE*cos(330*RAD), R_SLE*sin(330*RAD), 0.181};
//const		VECTOR3		SLE04_DIR = {-cos(255*RAD)*sin(30*RAD), -sin(255*RAD)*sin(30*RAD), cos(30*RAD)};

const		VECTOR3		A_REF = {0, 0.0, 1.7};

const		int			CMD_SHUTE_DOOR_OPEN = 0;
const		int			CMD_REENTRY_SHIELD_SEP = 1;
const		int			CMD_SLE_ON = 2;
const		int			CMD_BRAKE_SHUTE = 3;
const		int			CMD_BRAKE_SHUTE_SEP = 4;
const		int			CMD_MAIN_SHUTE = 5;
const		int			CMD_MAIN_SHUTE_SEP = 6;

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
DLLCLBK	void InitModule(HINSTANCE hModule)
{
	h_DLL = hModule;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
DLLCLBK void ExitModule(HINSTANCE hModule)
{

}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CoeffFuncV(double aoa, double M, double Re, double *cl, double *cm, double *cd)
{
	const int nlift = 11;
	const double factor=1.0;

	static const double AOA[nlift] = {-180*RAD,-160*RAD,-150*RAD,-120*RAD,-90*RAD,0*RAD,90*RAD,120*RAD,150*RAD,160*RAD,180*RAD};
	static const double CL[nlift]  = {0.0, -0.21, -0.3, -0.15, 0.0, 0.0, 0.0, 0.15, 0.3, 0.21, 0.0};
	static const double CM[nlift]  = {0.0, 0.004, 0.006, 0.012, 0.015, 0.0, -0.015, -0.012, -0.006, -0.004, 0.0};
	static const double CD[nlift]  = {1.6, 1.4, 1.0, 0.6, 0.75, 0, 0.75, 0.6, 1.0, 1.4, 1.6};

	static double SCL[nlift-1];
	static double SCM[nlift-1];
	static double SCD[nlift-1];

	for(int j = 0; j < nlift-1; j++)
	{
		SCL[j]= (CL[j+1]-CL[j])/(AOA[j+1]-AOA[j]);
		SCM[j]= (CM[j+1]-CM[j])/(AOA[j+1]-AOA[j]);
		SCD[j]= (CD[j+1]-CD[j])/(AOA[j+1]-AOA[j]);
	}

	for (int i = 0; i < nlift-1 && AOA[i+1] < aoa; i++);

	*cl = 1.0*(CL[i] + (aoa-AOA[i])*SCL[i]);
	*cm = factor*(CM[i] + (aoa-AOA[i])*SCM[i]);
	*cd = (CD[i] + (aoa-AOA[i])*SCD[i]);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CoeffFuncH(double beta, double M, double Re, double *cl, double *cm, double *cd)
{
	const int nlift = 11;
	const double factor=0.0;

	static const double BETA[nlift] = {-180*RAD,-160*RAD,-140*RAD,-120*RAD,-90*RAD,0*RAD,90*RAD,120*RAD,140*RAD,160*RAD,180*RAD};
	static const double CL[nlift]  = {0.0, -0.21, -0.3, -0.15, 0.0, 0.0, 0.0, 0.15, 0.3, 0.21, 0.0};
	static const double CM[nlift]  = {0.0, 0.004, 0.006, 0.012, 0.015, 0.0, -0.015, -0.012, -0.006, -0.004, 0.0};
	static const double CD[nlift]  = {1.6, 1.4, 1.0, 0.6, 0.75, 0, 0.75, 0.6, 1.0, 1.4, 1.6};

	static double SCL[nlift-1];
	static double SCM[nlift-1];
	static double SCD[nlift-1];

	for(int j = 0; j < nlift-1; j++)
	{
		SCL[j]= (CL[j+1]-CL[j])/(BETA[j+1]-BETA[j]);
		SCM[j]= (CM[j+1]-CM[j])/(BETA[j+1]-BETA[j]);
		SCD[j]= (CD[j+1]-CD[j])/(BETA[j+1]-BETA[j]);
	}

	for (int i = 0; i < nlift-1 && BETA[i+1] < beta; i++);

	*cl = 0.0*(CL[i] + (beta-BETA[i])*SCL[i]);
	*cm = factor*(CM[i] + (beta-BETA[i])*SCM[i]);
	*cd = (CD[i] + (beta-BETA[i])*SCD[i]);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
soyuz_capsule::soyuz_capsule(OBJHANDLE hObj, int fmodel): VESSEL2(hObj, fmodel)
{
	memset(&psc, 0, sizeof(psc));
	psc.srcsize = 0.15;
	psc.srcrate = 1000;
	psc.v0 = 10;
	psc.srcspread = 0.01;
	psc.lifetime = 0.1;
	psc.growthrate = 5;
	psc.atmslowdown = 0.1;
	psc.ltype = PARTICLESTREAMSPEC::DIFFUSE;
	psc.levelmap = PARTICLESTREAMSPEC::LVL_PSQRT;
	psc.lmin = 0;
	psc.lmax = 0.5;
	psc.atmsmap = PARTICLESTREAMSPEC::ATM_PLIN;
	psc.amin = 0.0;
	psc.amax = 0.5;
	
	MeshCount = 0;
	Far = 0;
	ShuteDoorOpen = 0;
	BrakeShute = 0;
	BrakeShuteSep = 0;
	MainShute = 0;
	MainShuteSep = 0;
	PsiBS = PhiBS = 0;
	BrakeShuteMeshIndex = MainShuteMeshIndex = -1;
	Separated = 1;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_capsule::clbkLoadStateEx(FILEHANDLE scn, void *status)
{
	char *line;

	while (oapiReadScenario_nextline(scn, line))
	{
		if (!strnicmp (line, "MESHNAME", 8))
		{
			sscanf (line+8, "%s", &MeshName);
		}

		if (!strnicmp (line, "DOORMESHNAME", 12))
		{
			sscanf (line+12, "%s", &DoorMeshName);
		}

		if (!strnicmp (line, "SHUTENAME01", 11))
		{
			sscanf (line+11, "%s", &MainShuteName);
		}

		if (!strnicmp (line, "SHUTENAME02", 11))
		{
			sscanf (line+11, "%s", &BrakeShuteName);
		}

		if (!strnicmp (line, "FAR", 3))
		{
			sscanf (line+3, "%i", &Far);
		}

		if (!strnicmp (line, "MESHCOUNT", 9))
		{
			sscanf (line+9, "%i", &MeshCount);
		}

		if (!strnicmp (line, "SHUTEDOOR", 9))
		{
			sscanf (line+9, "%i", &ShuteDoorOpen);
		}

		if (!strnicmp (line, "BRAKESHUTE", 10))
		{
			sscanf (line+10, "%i", &BrakeShute);
		}

		if (!strnicmp (line, "BRAKESHUTESEP", 13))
		{
			sscanf (line+13, "%i", &BrakeShuteSep);
		}

		if (!strnicmp (line, "BSINDEX", 7))
		{
			sscanf (line+7, "%i", &BrakeShuteMeshIndex);
		}

		if (!strnicmp (line, "PSIBS", 5))
		{
			float buf;
			sscanf (line+5, "%f", &buf);
			PsiBS = (double) buf;
		}

		if (!strnicmp (line, "PHIBS", 5))
		{
			float buf;
			sscanf (line+5, "%f", &buf);
			PhiBS = (double) buf;
		}

		if (!strnicmp (line, "MAINSHUTE", 9))
		{
			sscanf (line+9, "%i", &MainShute);
		}

		if (!strnicmp (line, "MAINSHUTESEP", 12))
		{
			sscanf (line+12, "%i", &MainShuteSep);
		}

		if (!strnicmp (line, "MSINDEX", 7))
		{
			sscanf (line+7, "%i", &MainShuteMeshIndex);
		}

		if (!strnicmp (line, "PSIMS", 5))
		{
			float buf;
			sscanf (line+5, "%f", &buf);
			PsiMS = (double) buf;
		}

		if (!strnicmp (line, "PHIMS", 5))
		{
			float buf;
			sscanf (line+5, "%f", &buf);
			PhiMS = (double) buf;
		}

		if (!strnicmp (line, "SEPARATED", 9))
		{
			sscanf (line+9, "%i", &Separated);
		}

		ParseScenarioLineEx(line, status);
	}

	hsoyuz_capsule = oapiLoadMeshGlobal(MeshName);
	hDoorMesh = oapiLoadMeshGlobal(DoorMeshName);
	hMainShute = oapiLoadMeshGlobal(MainShuteName);
	hBrakeShute = oapiLoadMeshGlobal(BrakeShuteName);

	AddMesh(hsoyuz_capsule); //0
	MeshCount = 0;
	Door_Shift = Door_Shift - COGro;
	AddMesh(hDoorMesh, &Door_Shift); //1
	MeshCount++;

	if ( (BrakeShuteMeshIndex > 0) && (!BrakeShuteSep) ) 
	{
		Brake_Shute_Shift = Brake_Shute_Shift - COGro;
		BrakeShuteMeshIndex = AddMesh(hBrakeShute, &Brake_Shute_Shift);
	}

	if ( (MainShuteMeshIndex > 0) && (!MainShuteSep) )
	{
		Main_Shute_Shift = Main_Shute_Shift - COGro;
		MainShuteMeshIndex = AddMesh(hMainShute, &Main_Shute_Shift);
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_capsule::clbkSaveState(FILEHANDLE scn)
{
	VESSEL2::clbkSaveState(scn);
	oapiWriteScenario_string(scn, "MESHNAME", MeshName);
	oapiWriteScenario_string(scn, "DOORMESHNAME", DoorMeshName);
	oapiWriteScenario_string(scn, "SHUTENAME01", MainShuteName);
	oapiWriteScenario_string(scn, "SHUTENAME02", BrakeShuteName);
	oapiWriteScenario_int(scn, "FAR", Far);
	oapiWriteScenario_int(scn, "MESHCOUNT", MeshCount);
	oapiWriteScenario_int(scn, "SHUTEDOOR", ShuteDoorOpen);

	oapiWriteScenario_int(scn, "BRAKESHUTE", BrakeShute);
	oapiWriteScenario_int(scn, "BRAKESHUTESEP", BrakeShuteSep);
	oapiWriteScenario_int(scn, "BSINDEX", BrakeShuteMeshIndex);
	oapiWriteScenario_float(scn, "PSIBS", PsiBS);
	oapiWriteScenario_float(scn, "PHIBS", PhiBS);

	oapiWriteScenario_int(scn, "MAINSHUTE", MainShute);
	oapiWriteScenario_int(scn, "MAINSHUTESEP", MainShuteSep);
	oapiWriteScenario_int(scn, "MSINDEX", MainShuteMeshIndex);
	oapiWriteScenario_float(scn, "PSIMS", PsiMS);
	oapiWriteScenario_float(scn, "PHIMS", PhiMS);

	oapiWriteScenario_int(scn, "SEPARATED", Separated);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_capsule::clbkSetClassCaps(FILEHANDLE cfg)
{
	VECTOR3 AB;
	
	SetSize(1.2);
	SetEmptyMass(EMPTY_MASS);
	SetCrossSections(CS);
	//SetCrossSections(_V(0, 0, 0));
	SetPMI(PMI);
	//SetCW(5.5, 0.1, 3.4, 3.4);
	SetCW(0, 0, 0, 0);
	SetRotDrag(RotDrag);
	SetSurfaceFrictionCoeff(1e5, 1e5);
	SetTouchdownPoints(TP1 - COGro, TP2 - COGro, TP3 - COGro);

	hReentryShield = CreateAttachment(false,
									  RS_REF - COGro,
									  RS_DIR,
									  RS_ROT,
									  "ReentryShield",
									  false);//p0

	hShuteDoor = CreateAttachment(false,
								  SD_REF - COGro,
								  SD_DIR,
								  SD_ROT,
								  "ShuteDoor",
								  false);//p1

	ph_sle = CreatePropellantResource(SLE_CAPACITY);
	
	AB = COGro - SLE01_REF;
	SLE01_DIR = AB*(1/length(AB));
	AB = COGro - SLE02_REF;
	SLE02_DIR = AB*(1/length(AB));
	AB = COGro - SLE03_REF;
	SLE03_DIR = AB*(1/length(AB));
	AB = COGro - SLE04_REF;
	SLE04_DIR = AB*(1/length(AB));
	
	th_sle[0] = CreateThruster(SLE01_REF - COGro,
		                       SLE01_DIR,
							   SLE_MAX_THRUST,
							   ph_sle,
							   SLE_ISP);

	th_sle[1] = CreateThruster(SLE02_REF - COGro,
		                       SLE02_DIR,
							   SLE_MAX_THRUST,
							   ph_sle,
							   SLE_ISP);

	th_sle[2] = CreateThruster(SLE03_REF - COGro,
		                       SLE03_DIR,
							   SLE_MAX_THRUST,
							   ph_sle,
							   SLE_ISP);

	th_sle[3] = CreateThruster(SLE04_REF - COGro,
		                       SLE04_DIR,
							   SLE_MAX_THRUST,
							   ph_sle,
							   SLE_ISP);

	//thg_main = CreateThrusterGroup(th_sle, 4, THGROUP_MAIN);

	AddExhaustStream(th_sle[0], &psc);
	AddExhaustStream(th_sle[1], &psc);
	AddExhaustStream(th_sle[2], &psc);
	AddExhaustStream(th_sle[3], &psc);

	hAirfoilV = CreateAirfoil2(LIFT_VERTICAL, A_REF - COGro, CoeffFuncV, 3.5, 3.0, 1.0);
	//hAirfoilH = CreateAirfoil2(LIFT_HORIZONTAL, A_REF - COGro, CoeffFuncH, 3.5, 3.0, 1.0);
	BrakeShuteDrag = 0.1;
	MainShuteDrag = 0.1;
	CreateVariableDragElement(&BrakeShuteDrag, S02, SD_REF - COGro);
	CreateVariableDragElement(&MainShuteDrag, S01, Main_Shute_Shift - COGro);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_capsule::clbkPostStep(double simt, double SimDT, double mjd)
{
	if (BrakeShute)
	{
		double M1 = GetMachNumber();
		BrakeShuteDrag = 7*(oapiGetWaveDrag(M1, 0.8, 0.98, 1.314, 0.28) + 0.1);

				
		Brake_DIR = Brake_Shute_Shift;
		Brake_DIR = Brake_DIR*(1/length(Brake_DIR));
		double cos_x = Brake_DIR.y/cos(asin(Brake_DIR.z));
		double sin_x = Brake_DIR.x/cos(asin(Brake_DIR.z));
		
		double phiZ = asin(Brake_DIR.z);
		double psiZ = atan2(sin_x, cos_x);

		BrakeShuteMeshRotate(-psiZ, PI/2 - phiZ, BrakeShuteMeshIndex);
	}
	else
		BrakeShuteDrag = 0;

	if (MainShute)
	{
		double M1 = GetMachNumber();
		MainShuteDrag = (oapiGetWaveDrag(M1, 0.8, 0.98, 1.314, 0.28) + 0.1);

		Main_DIR = Main_Shute_Shift;
		Main_DIR = Main_DIR*(1/length(Main_DIR));
		double cos_x = Main_DIR.y/cos(asin(Main_DIR.z));
		double sin_x = Main_DIR.x/cos(asin(Main_DIR.z));

		double phiZ = asin(Main_DIR.z);
		double psiZ = atan2(sin_x, cos_x);
		
		MainShuteMeshRotate(psiZ, -(PI/2 - phiZ), MainShuteMeshIndex);
	}
	else
		MainShuteDrag = 0;
	
	//CommandExec(CMD_BRAKE_SHUTE);
	//CommandExec(CMD_MAIN_SHUTE);
	LandingProgram(simt, SimDT);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_capsule::clbkVisualCreated(VISHANDLE visual, int refcount)
{
	if (refcount > 1) return;
	vis = visual;
	Far = 1;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_capsule::clbkVisualDestroyed(VISHANDLE visual, int refcount)
{
	if (visual == vis) 
	{
		vis = NULL;
		Far = 0;
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
int soyuz_capsule::clbkConsumeDirectKey(char *keystate)
{
	if (KEYDOWN(keystate, OAPI_KEY_J))
	{
		CommandExec(CMD_SHUTE_DOOR_OPEN);		
	}

	if (KEYDOWN(keystate, OAPI_KEY_O))
	{
		CommandExec(CMD_REENTRY_SHIELD_SEP);
		//CommandExec(CMD_SLE_ON);
	}	

	return 0;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
int soyuz_capsule::clbkConsumeBufferedKey(DWORD key, bool down, char *kstate)
{
	if ( (key == OAPI_KEY_S) && (!down) )
	{
		CommandExec(CMD_BRAKE_SHUTE_SEP);
		return 1;
	}

	if ( (key == OAPI_KEY_A) && (!down) )
	{
		CommandExec(CMD_MAIN_SHUTE_SEP);
		return 1;
	}
	
	return 0;
} 


//=============================================================================
//
//=============================================================================
DLLCLBK VESSEL *ovcInit(OBJHANDLE hvessel, int flightmodel)
{
	return new soyuz_capsule(hvessel, flightmodel);
}

DLLCLBK void ovcExit(VESSEL *vessel)
{
	if (vessel) delete (soyuz_capsule*) vessel;
}

//=============================================================================
//
//=============================================================================

void soyuz_capsule::CommandExec(int command)
{
	switch (command)
	{
	case CMD_SHUTE_DOOR_OPEN:
		{
			DetachChild(hShuteDoor, 10);
			ShuteDoorOpen = 1;
			break;
		}
	case CMD_REENTRY_SHIELD_SEP:
		{
			DetachChild(hReentryShield, 10);
			break;
		}
	case CMD_SLE_ON:
		{
			SetThrusterLevel(th_sle[0], 1.0);
			SetThrusterLevel(th_sle[1], 1.0);
			SetThrusterLevel(th_sle[2], 1.0);
			SetThrusterLevel(th_sle[3], 1.0);
			break;
		}
	case CMD_BRAKE_SHUTE:
		{
			if ( (ShuteDoorOpen) && (!BrakeShute) && (!BrakeShuteSep) )
			{
				Brake_Shute_Shift = Brake_Shute_Shift - COGro;
				BrakeShuteMeshIndex = AddMesh(hBrakeShute, &Brake_Shute_Shift);
				BrakeShute = 1;
			}
			break;
		}
	case CMD_BRAKE_SHUTE_SEP:
		{
			if ( (BrakeShute) && (!BrakeShuteSep) )
			{
				BrakeShute = 0;
				BrakeShuteSep = 1;
				DelMesh(BrakeShuteMeshIndex, false);
			}
			break;
		}
	case CMD_MAIN_SHUTE:
		{
			if ( (ShuteDoorOpen) && (BrakeShuteSep) && (!MainShute) && (!MainShuteSep) )
			{
				Main_Shute_Shift = Main_Shute_Shift - COGro;
				MainShuteMeshIndex = AddMesh(hMainShute, &Main_Shute_Shift);
				MainShute = 1;
			}
			break;
		}
	case CMD_MAIN_SHUTE_SEP:
		{
			if ( (MainShute) && (!MainShuteSep) )
			{
				MainShute = 0;
				MainShuteSep = 1;
				DelMesh(MainShuteMeshIndex, false);
			}
			break;
		}
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_capsule::BrakeShuteMeshRotate(double psi, double phi, int n)
{
	double psi0 = PsiBS;
	double phi0 = PhiBS;

	PsiBS = psi;
	PhiBS = phi;
	
	if (!vis) return;
	mt01.transform = MESHGROUP_TRANSFORM::ROTATE;
	mt01.nmesh = n;
	mt01.ngrp = -1;
	mt01.P.rotparam.angle = phi - phi0;
	mt01.P.rotparam.ref = _V(0, 0, 0);
	mt01.P.rotparam.axis = _V(cos(psi), sin(psi), 0);
	if (Far) MeshgroupTransform(vis, mt01);

	//mt01.transform = MESHGROUP_TRANSFORM::ROTATE;
	//mt01.nmesh = n;
	//mt01.ngrp = -1;
	//mt01.P.rotparam.angle = psi - psi0;
	//mt01.P.rotparam.ref = _V(0, 0, 0);
	//mt01.P.rotparam.axis = _V(0, 0, 1);
	//if (Far) MeshgroupTransform(vis, mt01);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_capsule::MainShuteMeshRotate(double psi, double phi, int n)
{
	double psi0 = PsiMS;
	double phi0 = PhiMS;

	PsiMS = psi;
	PhiMS = phi;
	
	if (!vis) return;
	mt01.transform = MESHGROUP_TRANSFORM::ROTATE;
	mt01.nmesh = n;
	mt01.ngrp = -1;
	mt01.P.rotparam.angle = phi - phi0;
	mt01.P.rotparam.ref = _V(0, 0, 0);
	mt01.P.rotparam.axis = _V(cos(psi), sin(psi), 0);
	if (Far) MeshgroupTransform(vis, mt01);

	/*mt01.transform = MESHGROUP_TRANSFORM::ROTATE;
	mt01.nmesh = n;
	mt01.ngrp = -1;
	mt01.P.rotparam.angle = psi - psi0;
	mt01.P.rotparam.ref = _V(0, 0, 0);
	mt01.P.rotparam.axis = _V(0, 0, 1);
	if (Far) MeshgroupTransform(vis, mt01);*/	
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_capsule::LandingProgram(double t, double dt)
{
	double H = GetAltitude();

	if (H <= 10000)
	{
		CommandExec(CMD_SHUTE_DOOR_OPEN);
		CommandExec(CMD_BRAKE_SHUTE);
	}

	if (H <= 4000)
	{
		CommandExec(CMD_BRAKE_SHUTE_SEP);
		CommandExec(CMD_MAIN_SHUTE);
	}

	if (H <= 20)
	{
		CommandExec(CMD_REENTRY_SHIELD_SEP);		
	}
	
	if (H <= 4)
	{
		CommandExec(CMD_MAIN_SHUTE_SEP);
		CommandExec(CMD_SLE_ON);
	}
}




